import pandas as pd
from sklearn.model_selection import train_test_split
from sklearn.preprocessing import StandardScaler
from sklearn.linear_model import LogisticRegression
from sklearn.metrics import accuracy_score
import os

# Load the Iris dataset from a local CSV file
df = pd.read_csv("08dd50f7-b254-45d5-85e6-45c778ebdaf9/datafile.csv")

# Compute basic statistics
stats = df.describe()

# Separate features and target
X = df.iloc[:, :-1]
y = df.iloc[:, -1]

# Split data into training and testing sets
X_train, X_test, y_train, y_test = train_test_split(X, y, test_size=0.2, random_state=42)

# Standardize features
scaler = StandardScaler()
X_train = scaler.fit_transform(X_train)
X_test = scaler.transform(X_test)

# Train a simple logistic regression model
model = LogisticRegression(max_iter=200)
model.fit(X_train, y_train)

# Make predictions
y_pred = model.predict(X_test)

# Compute accuracy
accuracy = accuracy_score(y_test, y_pred)


os.makedirs("results", exist_ok=True)
with open("results/classification_results.txt", "a") as f:
    f.write("Classification Accuracy: " + str(accuracy) + "\n")

# Save statistics to a text file
with open("results/statistics.txt", "w") as f:
    f.write("Basic Statistics:\n")
    f.write(stats.to_string())
    f.write("\n\n")
