import csv
import os
from datetime import datetime
import json

# Load dataset ID list from environment variable
dataset_ids = json.loads(os.getenv("RAISE_DATASET_ID_LIST"))


#csv_file_path = './registered-patients.csv'
#csv_file_path = '08de0574-7de7-4b89-8116-1ecab353cb7b/datafile.csv'
csv_file_path = f"{dataset_ids[0]}/datafile.csv"
monthly_counts = {}

with open(csv_file_path, newline='', encoding='utf-8') as csvfile:
    reader = csv.reader(csvfile)
    next(reader)

    for row in reader:
        try:
            register_date = row[2]
            date_obj = datetime.strptime(register_date, '%Y-%m-%d')
            month_str = date_obj.strftime('%Y-%m')
            if month_str in monthly_counts:
                monthly_counts[month_str] += 1
            else:
                monthly_counts[month_str] = 1
        except (IndexError, ValueError) as e:
            print(f"Skipping row due to error: {e}")

os.makedirs("results", exist_ok=True)
with open("results/patients_registered.txt", "a") as f:
    for month in sorted(monthly_counts):
        f.write(f'{month}: {monthly_counts[month]} patients registered' + '\n')
    